/*
	
*/

var ScrSizeHex = 8;
var ScrSizeDec = 11;
var ScrSizeBin = ScrSizeHex << 2;

var iStackSize = 25;
var iHexaNum = 8;
var iBitsNum = iHexaNum << 2;

var NumStack, OpStack;
var iNumStackLen = -1, iOpStackLen = -1;
var bRes=true, bErr=false, bChange=true;

var refBase = 16;

var iMem = 0;

////////////////////// Mac Cut Copy Paste //////////////////////
function docut(event) 
{
	//just do the same thing for cut and copy
	docopy(event);
}

/*!
 @funciton docopy
 copy the current value to the clipboard
*/
function docopy(event) 
{
	var display = "";
	switch(refBase)
	{
		case 16:
			display = document.Calc.ScreenHex.value;
			break;
		case 10:
			display = document.Calc.ScreenDec.value;
			break;
		case 2:
			display = document.Calc.ScreenBin.value;
			break;
	}
	
	event.clipboardData.setData('text/plain', display);
	event.preventDefault();
	event.stopPropagation();
}

function dopaste (event) 
{
	var clip = event.clipboardData.getData('text/plain');
	
	//loop over the clipboard
	var plen = clip.length;
	for(var i = 0; i < plen; i++)
	{
		//add the digit - note this will take care of putting the
		//value in the right place, and will ignore bad values
		AddDigit(""+clip[i]);
	}

	event.preventDefault();
	event.stopPropagation();
}
////////////////////// Mac Cut Copy Paste //////////////////////

function SubString(text, debut, fin)	
{
 	var debut = Math.max(0, debut);
 	var fin = Math.min(text.length, fin);
 	
 	if (fin > debut)
		return text.substring(debut,fin);
	else
		return '';
}

function InitTab(iNum)
{ 
	this.length = iNum; 
}

function Clear(bClrScr) 
{ 
	iNumStackLen=iOpStackLen=0;
	bRes=bChange=true;
	bErr=false;
	
 	if (bClrScr)
	{ 
		document.Calc.ScreenHex.value = '0';
		document.Calc.ScreenDec.value = '0';
		document.Calc.ScreenBin.value = '0';
  	}
}

function GetScreen(base)
{
	if (2 == base)
		return document.Calc.ScreenBin.value;
	if (10 == base)
		return document.Calc.ScreenDec.value;
		
	return document.Calc.ScreenHex.value;
}

function SetScreen(sText, base)
{
	if (2 == base)
		document.Calc.ScreenBin.value=sText;
	else
		if (10 == base)
			if (''+sText =='NaN')
				document.Calc.ScreenDec.value='0';
			else
				document.Calc.ScreenDec.value=sText;
		else
			document.Calc.ScreenHex.value=sText;
}

function GetScreenValue(base)
{ 
	var s = GetScreen(base);
	var res=0;
	
	if (base == 10) 
		return parseInt(s);
	if (base == 2)
		for (i=0; i<s.length; i++)
			if ( (s.charAt(i) != '0') && (s.charAt(i) != '1') )
				continue;
			else
				res=(res<<1) + parseInt(s.charAt(i), 2);
	else
		for (i=0; i<s.length; i++)
			if (   ((s.charAt(i)<'0') || (s.charAt(i)>'9'))
				&& ((s.charAt(i)<'A') || (s.charAt(i)>'F'))
				&& ((s.charAt(i)<'a') || (s.charAt(i)>'f')) )
				continue;
			else
				res=(res<<4) + parseInt(s.charAt(i), 16);
	return res;
}

var chiffres="0123456789ABCDEF";

function SetRefBase(base)
{ 
	refBase = base;
	for (i=0; i<base; i++)
		if (i<10)
			eval('document.Calc.b' + i + '.value="  ' + i + ' "');
		else
			eval('document.Calc.b' + i + '.value=" ' + chiffres.charAt(i) + ' "');
			
		for (i=base; i<16; i++)
			eval('document.Calc.b' + i + '.value=""');
}

/*!
 @function SwtichRadix
 chage the base radix and the visible control
 @param base
*/
function SwtichRadix(base)
{
	var domi2 = document.getElementById("ti2");
	var domi10 = document.getElementById("ti10");
	var domi16 = document.getElementById("ti16");

	switch(base)
	{
		case 2:
			domi2.style.visibility = "visible";
			domi10.style.visibility = "hidden";
			domi16.style.visibility = "hidden";
			break;
		case 10:
			domi2.style.visibility = "hidden";
			domi10.style.visibility = "visible";
			domi16.style.visibility = "hidden";
			break;
		case 16:
			domi2.style.visibility = "hidden";
			domi10.style.visibility = "hidden";
			domi16.style.visibility = "visible";
			break;
	}
	
	SetRefBase(base);
}


function ConvertTo(iValue, base)
{ 
	var s='';
	if (base == 10) 
		return iValue;
	if (iValue == 0) 
		return '0';
	
	if (iValue > 0)
		if (base == 2)
			for(; iValue>0; iValue>>>=1)
				s='' + (iValue & 1) + s;
		else
		 	for(; iValue>0; iValue>>>=4)
			{ 
				var iDigit=iValue & 15;
				if (iDigit < 10)
					s='' + iDigit + s;
				else
			  		s='' + unescape('%4' + (iDigit-9)) + s;
			}
	else
		if(base == 2)
			for(iValue=-iValue -1, i=0 ; i<(iHexaNum<<2); iValue>>>=1, i++)
				s='' + ( (~ iValue) & 1 ) + s;
		else
			for (iValue=-iValue -1, i=0 ; i<iHexaNum; iValue>>>=4, i++)
			{ 
		  		var iDigit=15 - (iValue & 15);
				if(iDigit < 10)
			  		s='' + iDigit + s;
				else
			  		s='' + unescape('%4' + (iDigit-9)) + s;
			}
	return s;
}

function SetToValidNumber(base)
{ 
	if(bErr) 
		return;
	if(base == 2)
		SetScreen(GetScreenValue(2), 10);
	else
		if(base == 10)
			SetScreen(GetScreenValue(10), 10);
		else
			SetScreen(GetScreenValue(16), 10);
	  
	SetScreen(ConvertTo(GetScreenValue(10), 2), 2);
	SetScreen(ConvertTo(GetScreenValue(10), 16), 16);
	bChange = true;
}

/*!
 @function InitCalc
 startup function for the calculator
*/
function InitCalc()
{ 
	// Already Initialized
	if (iNumStackLen != -1) 
		return; 
		
	NumStack = new InitTab(iStackSize);
	OpStack = new InitTab(iStackSize);
	
	SwtichRadix(16);
	
	Clear(false);
	
	SetToValidNumber(10);
}

/*!
 @function Error
 display an error
 @param sError the error text
*/
function Error(sError)
{ 
	bErr = bRes = true;
	dErrElement = document.getElementById("StatusMessage");
	
	//17 is the max length of the error stats bar
	if(sError.length > 17)
		sError = SubString(sError, 0, 17);
	
	dErrElement.innerHTML = sError;
	return 0;
}

function DelChar(sText,iPos)
{
	if ((iPos >= 0) && (iPos < sText.length))
		return SubString(sText, 0, iPos) + SubString(sText, iPos+1, sText.length);
	else
		return SubString(sText, 0, sText.length-1);
}

/*!
 @function AddDigit
 Add a digit to the current value stack
 @param sDigit
*/
function AddDigit(sDigit)
{ 
	if(bErr || (parseInt(sDigit,16) > refBase))  
		return;
	
	if(bRes)
	{  
		SetScreen(sDigit, refBase);
		bRes = false;
	}
	else
	{
		if( ((refBase==16) && (GetScreen(16).length < ScrSizeHex))
			|| ((refBase==10) && (GetScreen(10).length < ScrSizeDec))
			|| ((refBase==2) && (GetScreen(2).length < ScrSizeBin))
		)
		SetScreen(GetScreen(refBase) + sDigit, refBase);
	}
	SetToValidNumber(refBase);
}

/*!
 @function DelDigit
 delete a digit (backspace)
*/
function DelDigit(){ 
	if (bErr) 
		return;
	if (!bRes) SetScreen(DelChar(GetScreen(refBase),-1), refBase);
		SetToValidNumber(refBase);
}

/*!
 @function ChangeSign
 change from positive to negitive and vise versa
*/
function ChangeSign()
{ 
	if(bErr) 
		return;
	SetScreen(1 + ~ GetScreenValue(10), 10);
	SetToValidNumber(10);
	bRes = true;
}

function Not()
{ 
	if(bErr) 
		return;
	
	SetScreen(~ GetScreenValue(10), 10);
	StatusOp("not");
	SetToValidNumber(10);
	bRes = true;
}

/*!
 @function ManualEntry
 @param base the base to use
*/
function ManualEntry(base)
{ 
	if(2 == base)
	{
		document.Calc.ScreenDec.value = GetScreenValue(2);
	} 
	else if(16 == base) 
	{
		document.Calc.ScreenDec.value = GetScreenValue(16);	
	}
	else
	{
		SetToValidNumber(10);
	}
	
	bRes = bErr = false;
}

function MemoryMinus()
{ 
	if(bErr) 
		return;
	iMem -= GetScreenValue(10);
	bRes = true;
	
	MemoryStatus("M-");
}

function MemoryPlus()
{ 
	if(bErr) 
		return;
	iMem += GetScreenValue(10);
	bRes = true;
	
	MemoryStatus("M+");
}

function MemoryRestore()
{ 
	if(bErr) 
		return;
		
	document.Calc.ScreenDec.value=iMem;
	SetToValidNumber(10);
	bRes = true;
	
	MemoryStatus("RM");
}

function MemoryClear()
{ 
	iMem = 0;
	MemoryStatus("")
}

function GetOppLevel(sOpp)
{ 
	if (sOpp == "(") return -1;
	if ((sOpp == "<<") || (sOpp == ">>") || (sOpp == ">>>")) return 4;
	if ((sOpp == "or") || (sOpp == "and") || (sOpp == "xor")) return 3;
	if ((sOpp == "*") || (sOpp == "/")) return 2;
	if ((sOpp == "+") || (sOpp == "-")) return 1;
	return 0;
}

function Calculate(f1, f2, sOp)
{ 
	if (sOp == "+") return f1+f2;
	if (sOp == "-") return f1-f2;
	if (sOp == "*") return f1*f2;
	if (sOp == "/")
	if (f2 == 0)
		return Error("Division by zero");
	else
		return Math.floor(f1/f2);
	
	if (sOp == "or") return f1 | f2;
	if (sOp == "and") return f1 & f2;
	if (sOp == "xor") return f1 ^ f2;
	if (sOp == ">>") return f1 >> f2;
	if (sOp == ">>>") return f1 >>> f2;
	if (sOp == "<<") return f1 << f2;
	
	return Error("Invalid operator");
}

/*!
 @function PileUpOpp
 add an operator to the stack
 @param sOpp the operator
*/
function PileUpOpp(sOpp)
{ 
	if (!bChange) 
		return;
	if (iNumStackLen == -1) 
		InitCalc(); // Not Initialized

	if (bErr || (iNumStackLen >= iStackSize) || (iOpStackLen >= iStackSize) )
		Error("Stack overflow");
	else
	{ 
		NumStack[iNumStackLen++] = GetScreenValue(10);
		OpStack[iOpStackLen++] = sOpp;
		
		StatusOp(sOpp);
		
		while ( (iOpStackLen>=2) && ( GetOppLevel(OpStack[iOpStackLen-1])
			<= GetOppLevel(OpStack[iOpStackLen-2]) ) )
		{ 
			NumStack[iNumStackLen-2] = Calculate(
				NumStack[iNumStackLen-2],
				NumStack[iNumStackLen-1], 
				OpStack[iOpStackLen-2] 
			);
			
			if (!bErr) 
				SetScreen(NumStack[iNumStackLen-2], 10);
		  
		  	OpStack[iOpStackLen-2]=OpStack[iOpStackLen-1];
		  	
		  	iNumStackLen--;
		  	iOpStackLen--;
		}
		
		SetToValidNumber(10);
		bRes = true;
		bChange = false;
	}
}

function OpenBrackets()
{ 
	if(iNumStackLen == -1) 
		InitCalc(); // Not Initialized
	if(bErr || (iOpStackLen>=iStackSize))
		Error("Stack overflow");
	else
	{ 
		OpStack[iOpStackLen++] = "(";
		StatusOp("(");
		bRes = bChange = true;
	}
}

function CloseBrackets()
{ 
	while (iOpStackLen>=1)
	{
		if (OpStack[iOpStackLen-1] == "(")
		{ 
			StatusOp(")");
			iOpStackLen--;
			break;
		}
		
		var iRes = Calculate(
			NumStack[iNumStackLen-1], 
			GetScreenValue(10), 
			OpStack[iOpStackLen-1] 
		);

		if (!bErr) SetScreen(iRes, 10);
		iNumStackLen--;
		iOpStackLen--;
	  }
	  bRes=true;
	  SetToValidNumber(10);
}

function Equal()
{
	while (iOpStackLen >= 1)
	{
		CloseBrackets();
	}
	StatusOp("");
}

/*!
 sets the status bar operation to sOp
*/
function StatusOp(sOp)
{
	var dMemElement = document.getElementById("StatusLastOp");
	dMemElement.innerHTML = sOp;
}

function MemoryStatus(sOp)
{
	var dMemElement = document.getElementById("StatusMemoryOp");
	dMemElement.innerHTML = sOp;
}
